<?php
/*
Plugin Name: Fawry AI Article Generator
Description: أداة لتوليد المقالات باستخدام الذكاء الصناعي من Fawry Digital.
Version: 1.0
Author: Your Name
*/

// تعريف شورت كود لعرض الأداة
function fawry_ai_article_generator_shortcode() {
    ob_start();
    ?>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&amp;display=swap" rel="stylesheet">
    <style>
        /* CSS الخاص بالأداة */
        :root {
            --primary-blue: #0066cc;
            --light-blue: #e6f3ff;
            --white: #ffffff;
            --dark-blue: #004999;
            --gray: #666666;
        }

        .logo {
            width: 200px;
            height: auto;
            margin: 0 auto 20px;
            display: block;
            animation: logoFloat 3s ease-in-out infinite;
        }

        @keyframes logoFloat {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        .container {
            background: var(--white);
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 8px 30px rgba(0,0,0,0.12);
            width: 90%;
            max-width: 800px;
            margin: auto;
        }

        h1 {
            color: var(--primary-blue);
            text-align: center;
            margin-bottom: 40px;
            font-size: clamp(2em, 5vw, 3em);
            position: relative;
            padding-bottom: 20px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }

        h1::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 120px;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-blue), var(--dark-blue));
            border-radius: 4px;
        }

        .input-group {
            margin-bottom: 30px;
            position: relative;
        }

        textarea, input[type="url"] {
            width: 100%;
            padding: 20px;
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: #fafafa;
            box-shadow: inset 0 2px 4px rgba(0,0,0,0.05);
            box-sizing: border-box;
        }

        textarea {
            min-height: 150px;
            margin-bottom: 15px;
            resize: vertical;
        }

        textarea:focus, input:focus {
            outline: none;
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 3px rgba(0,102,204,0.15);
            background: var(--white);
        }

        .url-input {
            margin-bottom: 15px;
        }

        .toolbar {
            position: sticky;
            top: 20px;
            z-index: 100;
            background: var(--white);
            padding: 15px 0;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            margin-bottom: 20px;
            display: flex;
            justify-content: center;
            gap: 10px;
            flex-wrap: wrap;
        }

        button {
            background: linear-gradient(45deg, var(--primary-blue), var(--dark-blue));
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 12px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            box-shadow: 0 4px 15px rgba(0,102,204,0.2);
            min-width: 140px;
        }

        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,102,204,0.3);
        }

        button:active {
            transform: translateY(0);
        }

        .result {
            margin-top: 30px;
            padding: 30px;
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            background: var(--white);
            min-height: 300px;
            transition: all 0.3s ease;
            line-height: 1.8;
            font-size: 16px;
        }

        .result:focus {
            outline: none;
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 3px rgba(0,102,204,0.1);
        }

        .result h2 {
            color: var(--primary-blue);
            margin: 30px 0 15px;
            font-size: 1.8em;
            border-bottom: 2px solid var(--light-blue);
            padding-bottom: 10px;
        }

        .result h3 {
            color: var(--dark-blue);
            margin: 25px 0 15px;
            font-size: 1.4em;
        }

        .result p {
            margin-bottom: 15px;
            text-align: justify;
            line-height: 1.8;
        }

        .result br {
            display: block;
            margin: 10px 0;
            content: "";
        }

        .controls {
            margin-top: 25px;
            display: flex;
            gap: 15px;
            justify-content: center;
        }

        .loading {
            display: none;
            text-align: center;
            margin: 40px 0;
        }

        .loading-spinner {
            width: 60px;
            height: 60px;
            border: 5px solid var(--light-blue);
            border-top: 5px solid var(--primary-blue);
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes slideIn {
            from { transform: translateX(30px); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        .container {
            animation: fadeIn 0.8s ease-out;
        }

        .result > * {
            animation: slideIn 0.5s ease-out forwards;
        }

        button svg {
            width: 20px;
            height: 20px;
            fill: currentColor;
        }

        @media (max-width: 768px) {
            .container {
                padding: 20px;
                width: 95%;
            }

            .logo {
                width: 150px;
            }

            button {
                padding: 10px 20px;
                font-size: 14px;
                min-width: 120px;
            }

            .controls {
                flex-direction: column;
                align-items: stretch;
            }

            .result {
                padding: 20px;
            }
        }

        .seo-section {
            margin-top: 40px;
            padding: 25px;
            background: linear-gradient(135deg, var(--light-blue), #f0f7ff);
            border-radius: 12px;
            border: 2px solid var(--primary-blue);
        }

        .seo-section h3 {
            color: var(--dark-blue);
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .keywords-list {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-top: 15px;
        }

        .keyword-tag {
            background: var(--primary-blue);
            color: white;
            padding: 8px 15px;
            border-radius: 20px;
            font-size: 14px;
            animation: tagPop 0.3s ease-out forwards;
        }

        .suggested-title {
            background: var(--white);
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
            border-left: 4px solid var(--primary-blue);
        }

        @keyframes tagPop {
            from { transform: scale(0.8); opacity: 0; }
            to { transform: scale(1); opacity: 1; }
        }

        .copy-seo {
            background: var(--dark-blue);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 5px;
            margin-top: 15px;
        }

        .error-message {
            color: #721c24;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            padding: 15px;
            border-radius: 8px;
            margin: 10px 0;
            display: none;
            animation: slideIn 0.3s ease-out;
        }

        .popup-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.7);
            z-index: 1000;
            animation: fadeIn 0.3s ease-out;
        }

        .popup {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: var(--white);
            padding: 30px;
            border-radius: 15px;
            max-width: 500px;
            width: 90%;
            text-align: center;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            z-index: 1001;
            animation: popIn 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }

        .popup h3 {
            color: var(--primary-blue);
            margin-bottom: 20px;
            font-size: 1.5em;
        }

        .popup p {
            margin-bottom: 25px;
            line-height: 1.6;
        }

        .popup-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
        }

        .popup-button {
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .popup-button.primary {
            background: var(--primary-blue);
            color: white;
            border: none;
        }

        .popup-button.secondary {
            background: var(--light-blue);
            color: var(--primary-blue);
            border: 1px solid var(--primary-blue);
        }

        @keyframes popIn {
            0% { transform: translate(-50%, -50%) scale(0.8); opacity: 0; }
            100% { transform: translate(-50%, -50%) scale(1); opacity: 1; }
        }
    </style>
    <div class="container">
        <img src="https://fawry.digital/wp-content/uploads/2025/01/20250113_180556_٠٠٠٠-removebg-preview.png" alt="Fawry Digital Egypt Logo" class="logo">
        <h1>Fawry AI Art</h1>

        <div class="input-group">
            <input type="url" id="websiteUrl" class="url-input" placeholder="أدخل رابط الموقع (اختياري)" dir="rtl">
            <textarea id="topic" placeholder="اكتب موضوع المقال هنا..." dir="rtl"></textarea>
            <button onclick="generateArticle()">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                    <path d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10-4.477 10-10 10zm-1-11H7v2h4v4h2v-4h4v-2h-4V7h-2v4z"/>
                </svg>
                إنشاء المقال
            </button>
        </div>
        <div class="error-message" id="errorMessage"></div>

        <div class="loading" id="loading">
            <div class="loading-spinner"></div>
            <p>جارٍ إنشاء المقال...</p>
        </div>

        <div class="toolbar" id="toolbar">
            <button onclick="copyArticle()">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                    <path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/>
                </svg>
                نسخ المقال
            </button>
        </div>

        <div class="result" id="result" contenteditable="true" dir="rtl">
            النتيجة ستظهر هنا...
        </div>

        <div class="seo-section" id="seoSection" dir="rtl" style="display: none;">
            <h3>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M20 6H4V8H20V6ZM21 12H3V14H21V12ZM20 18H4V20H20V18Z" fill="currentColor"/>
                </svg>
                تحليل SEO للمقال
            </h3>
            <div class="suggested-title" id="suggestedTitle"></div>
            <div class="keywords-list" id="keywordsList"></div>
            <button class="copy-seo" onclick="copySEOInfo()">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                    <path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/>
                </svg>
                نسخ معلومات SEO
            </button>
        </div>
    </div>

    <div class="popup-overlay" id="recommendationPopup">
        <div class="popup" dir="rtl">
            <h3>اكتشف خدمات فوري ديجيتال</h3>
            <p>هل تريد تطوير حضورك الرقمي؟ اكتشف خدمات Fawry Digital المتكاملة .</p>
            <div class="popup-buttons">
                <button class="popup-button primary" onclick="window.open('https://fawry.digital', '_blank')">زيارة فوري ديجيتال</button>
                <button class="popup-button secondary" onclick="closeRecommendationPopup()">إغلاق</button>
            </div>
        </div>
    </div>

    <script type="module">
        import { GoogleGenerativeAI } from "https://esm.run/@google/generative-ai";

        async function analyzeWebsite(url) {
            try {
                const response = await fetch(url);
                const html = await response.text();
                const parser = new DOMParser();
                const doc = parser.parseFromString(html, 'text/html');
                const title = doc.title;
                const metaDescription = doc.querySelector('meta[name="description"]')?.content || '';
                const h1s = Array.from(doc.querySelectorAll('h1')).map(h => h.textContent);
                const h2s = Array.from(doc.querySelectorAll('h2')).map(h => h.textContent);
                const h3s = Array.from(doc.querySelectorAll('h3')).map(h => h.textContent);
                const links = Array.from(doc.querySelectorAll('a')).map(a => a.href);
                const images = Array.from(doc.querySelectorAll('img')).map(img => ({
                    src: img.src,
                    alt: img.alt
                }));
                const mainContent = doc.querySelector('main')?.textContent || doc.querySelector('article')?.textContent || doc.querySelector('[role="main"]')?.textContent || doc.body.textContent;
                const keywords = doc.querySelector('meta[name="keywords"]')?.content || '';
                const metaTags = Array.from(doc.querySelectorAll('meta')).reduce((acc, meta) => {
                    const name = meta.getAttribute('name') || meta.getAttribute('property');
                    const content = meta.getAttribute('content');
                    if (name && content) {
                        acc[name] = content;
                    }
                    return acc;
                }, {});
                const schemaScripts = Array.from(doc.querySelectorAll('script[type="application/ld+json"]')).map(script => {
                    try {
                        return JSON.parse(script.textContent);
                    } catch (e) {
                        return null;
                    }
                }).filter(data => data);
                return {
                    title,
                    metaDescription,
                    h1s,
                    h2s,
                    h3s,
                    keywords,
                    metaTags,
                    links,
                    images,
                    structuredData: schemaScripts,
                    mainContent: mainContent.substring(0, 7500)
                };
            } catch (error) {
                console.error('Error analyzing website:', error);
                throw error;
            }
        }

        window.generateArticle = async function () {
            const topic = document.getElementById('topic').value;
            const websiteUrl = document.getElementById('websiteUrl').value;
            if (!topic && !websiteUrl) {
                alert('الرجاء كتابة موضوع المقال أو إدخال رابط الموقع');
                return;
            }
            const loading = document.getElementById('loading');
            const result = document.getElementById('result');
            const seoSection = document.getElementById('seoSection');
            loading.style.display = 'block';
            result.innerHTML = '';
            seoSection.style.display = 'none';
            try {
                const genAI = new GoogleGenerativeAI('AIzaSyCJUWAUf2Pg_AbMQqw1Ke19c1cA3U9rtcg');
                const model = genAI.getGenerativeModel({
                    model: "gemini-pro"
                });
                let prompt = '';
                let websiteData = null;
                if (websiteUrl) {
                    try {
                        websiteData = await analyzeWebsite(websiteUrl);
                        prompt = `
                            قم بكتابة مقال شامل ومفصل باللغة العربية عن الموقع ${websiteUrl}.

                            تحليل تفصيلي للموقع:
                            العنوان: ${websiteData.title}
                            الوصف: ${websiteData.metaDescription}
                            العناوين الرئيسية: ${websiteData.h1s.join(', ')}
                            العناوين الفرعية: ${websiteData.h2s.join(', ')}
                            الكلمات المفتاحية: ${websiteData.keywords}

                            الروابط المهمة في الموقع:
                            ${websiteData.links.slice(0, 10).join('\n')}

                            الصور الرئيسية:
                            ${websiteData.images.slice(0, 5).map(img => `${img.alt}`).join('\n')}

                            البيانات المهيكلة:
                            ${JSON.stringify(websiteData.structuredData)}

                            المحتوى الرئيسي للموقع:
                            ${websiteData.mainContent}

                            يجب أن يتضمن المقال:
                            1. تحليل دقيق لنشاط الموقع ومجال عمله
                            2. وصف تفصيلي للخدمات أو المنتجات المقدمة
                            3. تحليل لنقاط القوة والمميزات
                            4. معلومات عن الجمهور المستهدف
                            5. تحليل لهيكلة المحتوى والتصميم
                            6. تقييم لأداء SEO والتحسينات المقترحة
                            7. مقارنة مع المنافسين في نفس المجال
                            8. توصيات وخطة عمل للتطوير`;
                    } catch (error) {
                        console.error('Failed to analyze website:', error);
                        prompt = `قم بكتابة مقال تحليلي شامل باللغة العربية عن الموقع ${websiteUrl}. يجب أن يتضمن المقال تحليلاً دقيقاً للموقع ومجال عمله والخدمات المقدمة.`;
                    }
                } else {
                    prompt = `قم بكتابة مقال شامل ومفصل باللغة العربية عن الموضوع التالي: ${topic}

                        اجعل المقال:
                        1. غني بالمعلومات الدقيقة والموثوقة
                        2. يغطي جميع جوانب الموضوع بعمق
                        3. مدعم بأمثلة وشروحات تفصيلية
                        4. يناسب القراء المهتمين بهذا المجال`;
                }
                prompt += `
                    متطلبات المقال:
                    - لا يقل عن 2500 كلمة
                    - هيكل احترافي يتضمن:
                        * عنوان رئيسي جذاب
                        * مقدمة شاملة توضح أهمية الموضوع
                        * أقسام رئيسية منظمة مع عناوين <h2>
                        * أقسام فرعية مع عناوين <h3>
                        * فقرات منسقة داخل وسوم <p>
                        * أمثلة وتوضيحات عملية
                        * خاتمة قوية مع توصيات
                    - تنسيق HTML احترافي
                    - محتوى مرتب ومتسلسل منطقياً
                    - لغة عربية فصحى سليمة
                    - معلومات دقيقة وحديثة
                `;
                const resultContent = await model.generateContent(prompt);
                const response = await resultContent.response;
                const cleanAndFormatText = text => {
                    return text.replace(/#{1,6}\s/g, '').replace(/\*\*/g, '').replace(/\*/g, '').replace(/\n\s*\n/g, '</p><p>').replace(/\n/g, '<br>').trim();
                };
                const text = cleanAndFormatText(response.text());
                document.getElementById('result').innerHTML = text;
                const seoPrompt = `حلل النص التالي واقترح:
                    1. عنوان SEO مثالي (عنوان رئيسي مناسب للمقال)
                    2. 5 كلمات مفتاحية مناسبة للمحتوى

                    النص: ${text.substring(0, 1500)}...

                    قم بالرد بتنسيق JSON كالتالي:
                    {
                        "title": "العنوان المقترح",
                        "keywords": ["كلمة1", "كلمة2", "كلمة3", "كلمة4", "كلمة5"]
                    }`;
                const seoResult = await model.generateContent(seoPrompt);
                const seoResponse = await seoResult.response;
                const seoData = JSON.parse(seoResponse.text());
                document.getElementById('suggestedTitle').innerHTML = `<strong>العنوان المقترح:</strong><br>${seoData.title}`;
                const keywordsHtml = seoData.keywords.map(keyword => `<span class="keyword-tag">${keyword}</span>`).join('');
                document.getElementById('keywordsList').innerHTML = keywordsHtml;
                seoSection.style.display = 'block';
            } catch (error) {
                console.error('Error:', error);
                const errorMessage = document.getElementById('errorMessage');
                errorMessage.style.display = 'block';
                errorMessage.textContent = error.message.includes('fetch') ? 'لم نتمكن من الوصول إلى الموقع. تأكد من صحة الرابط وأنه يسمح بالوصول.' : 'حدث خطأ أثناء إنشاء المقال. الرجاء المحاولة مرة أخرى.';
                result.innerHTML = 'حدث خطأ أثناء إنشاء المقال. الرجاء المحاولة مرة أخرى.';
            } finally {
                loading.style.display = 'none';
                setTimeout(() => {
                    showRecommendationPopup();
                }, 1000);
            }
        };

        window.copyArticle = function () {
            const articleText = document.getElementById('result').innerText;
            navigator.clipboard.writeText(articleText).then(() => {
                alert('تم نسخ المقال بنجاح!');
            }).catch(err => {
                console.error('خطأ في نسخ النص:', err);
                alert('حدث خطأ أثناء نسخ المقال');
            });
        };

        window.copySEOInfo = function () {
            const title = document.getElementById('suggestedTitle').innerText;
            const keywords = Array.from(document.querySelectorAll('.keyword-tag')).map(tag => tag.innerText).join('\n');
            const seoText = `${title}\n\nالكلمات المفتاحية:\n${keywords}`;
            navigator.clipboard.writeText(seoText).then(() => {
                alert('تم نسخ معلومات SEO بنجاح!');
            }).catch(err => {
                console.error('خطأ في نسخ النص:', err);
                alert('حدث خطأ أثناء نسخ المعلومات');
            });
        };

        function showRecommendationPopup() {
            document.getElementById('recommendationPopup').style.display = 'block';
            document.body.style.overflow = 'hidden';
        }

        window.closeRecommendationPopup = function () {
            document.getElementById('recommendationPopup').style.display = 'none';
            document.body.style.overflow = 'auto';
        };
    </script>
    <?php
    return ob_get_clean();
}

// تسجيل شورت كود
function register_fawry_ai_article_generator_shortcode() {
    add_shortcode('fawry_ai_article_generator', 'fawry_ai_article_generator_shortcode');
}
add_action('init', 'register_fawry_ai_article_generator_shortcode');